unit products;

interface

uses productsDB, StrUtils, System.Web.UI, System.Drawing, System.Web.UI.WebControls;




type csNovo = Class(System.Web.UI.WebControls.Table)
    constructor Create;
end;


type csTrazeno = Class(System.Web.UI.WebControls.Table)
    constructor Create;
end;


implementation

var
 aRow :  System.Web.UI.WebControls.TableRow;
 aCell : System.Web.UI.WebControls.TableCell;

type
  TItemTemplate = Class(System.Object,ITemplate)
     procedure InstantiateIn(container:System.Web.UI.Control);
     procedure DoDataBinding(Sender: System.Object; E: System.EventArgs);
     procedure DoNRDataBinding(Sender: System.Object; E: System.EventArgs);
end;

procedure TItemTemplate.DoDataBinding(Sender: System.Object; E:System.EventArgs);
var
    l:System.Web.UI.WebControls.HyperLink;
    container: System.Web.UI.WebControls.DataListItem;
begin
    l:=(Sender as System.Web.UI.WebControls.HyperLink);
    container := (l.NamingContainer as System.Web.UI.WebControls.DataListItem);
    l.Text := DataBinder.Eval((Container as DataListItem).DataItem, 'ProductName').ToString;
    l.NavigateURL:='webform1.aspx?id=' + DataBinder.Eval((Container as DataListItem).DataItem, 'ProductID').ToString;
    container.CssClass:='NormalSmall';
end;

procedure TItemTemplate.DoNRDataBinding(Sender: System.Object; E:System.EventArgs);
var
    l:System.Web.UI.WebControls.Label;
    container: System.Web.UI.WebControls.DataListItem;

	  sAppPayType:string;
	  sAppType:string;
begin
    l:=(Sender as System.Web.UI.WebControls.Label);
    container := (l.NamingContainer as System.Web.UI.WebControls.DataListItem);

	  sAppType:=DataBinder.Eval((Container as DataListItem).DataItem, 'AppType').ToString;
	  sAppPayType:=DataBinder.Eval((Container as DataListItem).DataItem, 'AppPayType').ToString;

    l.Text := l.Text +  '<a href="webform3.aspx?apptype=' + sAppType + '">' + sAppType + '</a><br> ';
    l.Text := l.Text +  '<a href="webform3.aspx?apppaytype=' + sAppPayType + '">' + sAppPayType + '</a><br>';

    l.CssClass:='NovoTrazeno';
end;

procedure TItemTemplate.InstantiateIn(container:System.Web.UI.Control);
 var
    aHL : System.Web.UI.WebControls.HyperLink;
    aNR : System.Web.UI.WebControls.Label;
begin
 container.Controls.Add(LiteralControl.create('<b>::</b> '));

 aHL := System.Web.UI.WebControls.HyperLink.Create;
 aHL.add_DataBinding(DoDataBinding);
 container.Controls.Add(aHL);

 container.Controls.Add(LiteralControl.create('<br>'));

 aNR := System.Web.UI.WebControls.Label.Create;
 aNR.add_DataBinding(DoNRDataBinding);
 container.Controls.Add(aNR);

end;

constructor csNovo.Create;
var
  prds : TproductsDB;
  MyList   : System.Web.UI.WebControls.DataList;
//  LnkMore  :  System.Web.UI.WebControls.HyperLink;
begin
    inherited create;

    prds := TproductsDB.Create;

    MyList := System.Web.UI.WebControls.DataList.Create;

    //MyList.DataKeyField := 'AppType';

    MyList.ItemTemplate := TItemTemplate.create;

    MyList.DataSource := prds.GetNew;
    MyList.DataBind;

    aRow:=TableRow.Create;
    aCell:=TableCell.Create;

    aCell.Controls.Add(MyList);

		//aCell.Controls.Add(LiteralControl.create('<br>'));

{
    aCell.Controls.Add(LiteralControl.create('<br>'));

    LnkMore:=HyperLink.Create;
    with LnkMore do
    begin
        Text:='Jos';
        NavigateURL := 'csnaj.aspx?show=new';
        CssClass:='NormalSmall';
    end;
    aCell.Controls.Add(LnkMore);
}

    aRow.Cells.Add(aCell);

    Rows.Add(aRow);
end;

constructor csTrazeno.Create;
var
  prds : TproductsDB;
  MyList   : System.Web.UI.WebControls.DataList;
//  LnkMore  :  System.Web.UI.WebControls.HyperLink;
begin
    inherited create;

    prds := TproductsDB.Create;

    MyList := System.Web.UI.WebControls.DataList.Create;

    //MyList.DataKeyField := 'AppType';

    MyList.ItemTemplate := TItemTemplate.create;

    MyList.DataSource := prds.GetTrazeno;
    MyList.DataBind;

    aRow:=TableRow.Create;
    aCell:=TableCell.Create;

    aCell.Controls.Add(MyList);


    aRow.Cells.Add(aCell);

    with Self do begin
        Width:=System.Web.UI.WebControls.Unit.Percentage(100);
        BorderWidth := System.Web.UI.WebControls.Unit.Pixel(0);
        CellPadding:=0;
        CellSpacing:=0;

        Rows.Add(aRow);
    end;

end;

end.
